package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.{Community, CommunityModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.{
  emitJsonLdObject,
  emitJsonLdObjectArray,
  emitScalarArrayField,
  emitScalarField
}
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryCommunityEmitter(community: Community) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, community, CommunityModel.Portal)
      emitScalarField(entryBuilder, community, CommunityModel.Version)
      emitScalarField(entryBuilder, community, CommunityModel.CreatedAt)

      emitJsonLdObjectArray(entryBuilder, community, CommunityModel.Profile) { target =>
        ProjectSummaryCommunityProfileEmitter(target)
      }

      emitJsonLdObject(entryBuilder, community, CommunityModel.Target) { target =>
        ProjectSummaryPortalTargetEmitter(target)
      }
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryCommunityEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryCommunityEmitter(Community(instance))
}
