package org.mulesoft.apb.project.internal.engine

import org.mulesoft.apb.project.client.scala.dependency.{
  Dependency,
  DesignDependency,
  ExtensionDependency,
  InvalidParsedDependency,
  ManagementDependency,
  ProfileDependency
}

import scala.collection.mutable.ListBuffer

object PartitionedDependencies {

  def apply(
      deps: Seq[Dependency]
  ): (
      List[DesignDependency],
      List[ProfileDependency],
      List[ExtensionDependency],
      List[ManagementDependency],
      List[InvalidParsedDependency]
  ) = {
    val design: ListBuffer[DesignDependency]         = ListBuffer.empty
    val profile: ListBuffer[ProfileDependency]       = ListBuffer.empty
    val extension: ListBuffer[ExtensionDependency]   = ListBuffer.empty
    val management: ListBuffer[ManagementDependency] = ListBuffer.empty
    val invalid: ListBuffer[InvalidParsedDependency] = ListBuffer.empty
    deps.foreach {
      case d: DesignDependency        => design += d
      case p: ProfileDependency       => profile += p
      case e: ExtensionDependency     => extension += e
      case m: ManagementDependency    => management += m
      case i: InvalidParsedDependency => invalid += i
      case _                          => // ignore
    }
    (design.toList, profile.toList, extension.toList, management.toList, invalid.toList)
  }
}
