package org.mulesoft.apb.project.internal.transformation

import amf.core.client.scala.transform.{TransformationPipeline, TransformationStep}
import org.mulesoft.apb.project.client.scala.DependencySet
import org.mulesoft.apb.project.client.scala.dependency.DesignDependency
import org.mulesoft.apb.project.internal.common.Classifier
import org.mulesoft.apb.project.internal.transformation.steps.{
  MetadataVariablesValidationStage,
  ReferenceLikeResolutionStage
}

case class APBTransformationPipeline(config: DependencySet, base: TransformationPipeline)
    extends TransformationPipeline {
  override val name: String = base.name

  override def steps: Seq[TransformationStep] = getApbSteps(config) ++ base.steps

  private def getApbSteps(config: DependencySet): Seq[TransformationStep] = {
    val base = Seq(new JSONDocumentRefCleaningTransformationStage())
    config.descriptor().classifier() match {
      case Some(Classifier.AGENT_NETWORK) =>
        base ++ Seq(new ReferenceLikeResolutionStage(config))
      case Some(classifier) if classifier.contains("raml") =>
        base ++ Seq(
          new CompanionLibCheckTransformationStage(fetchExtensionCompanions(config)),
          new AdoptionDependantCallsFixingTransformationStage
        )
      case _ => base
    }
  }

  private def fetchExtensionCompanions(config: DependencySet): Seq[DesignDependency] = config
    .designExtension()
    .flatMap(_.companionLibDependency())
}
