package org.mulesoft.apb.project.client.scala

import amf.aml.client.scala.model.document.Dialect
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.dependency._
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.model.report.APBResult
import org.mulesoft.apb.project.internal.dependency.APBResourceLoader
import org.mulesoft.apb.project.internal.engine.MigrationRisks
import org.mulesoft.apb.project.internal.listener.{
  AbsolutePathDetectionRawReferenceListener,
  InternalDependencyFileReferenceListener,
  RawReferenceListener
}

case class ProjectConfiguration(
    designDependencies: Seq[DesignDependency],
    profileDependencies: Seq[ProfileDependency],
    extensionDependencies: Seq[ExtensionDependency],
    managementDependencies: Seq[ManagementDependency],
    invalidDependencies: Seq[InvalidParsedDependency],
    dependencyLoaders: Map[String, ResourceLoader],
    descriptor: ProjectDescriptor,
    validationDialect: Dialect,
    unitCacheBuilder: UnitCacheBuilder = CloneOnceUnitCacheBuilder,
    envLoaders: List[ResourceLoader],
    results: Seq[APBResult],
    private[apb] val migrationRisks: MigrationRisks = MigrationRisks.empty
) extends DependencySet {

  override def mainLoader(): ResourceLoader = new APBResourceLoader(dependencyLoaders)

  override def design(): Seq[DesignDependency]             = designDependencies
  override def validation(): Seq[ProfileDependency]        = profileDependencies
  override def designExtension(): Seq[ExtensionDependency] = extensionDependencies
  override def management(): Seq[ManagementDependency]     = managementDependencies

  // TODO: WATCH OUT!! This is mutable
  lazy val absolutePathListener: Option[AbsolutePathDetectionRawReferenceListener] =
    AbsolutePathDetectionRawReferenceListener(descriptor)

  def getAnypointConfigListeners: Iterable[RawReferenceListener] =
    absolutePathListener ++ Seq(InternalDependencyFileReferenceListener(designDependencies))

  def getListeners(): Iterable[RawReferenceListener] =
    if (!descriptor.isLegacyDescriptor) getAnypointConfigListeners else Nil

  def mainFile: Option[String] = descriptor.main

  override def allDependencies(): Seq[ParsedDependency] =
    designDependencies ++ extensionDependencies ++ profileDependencies
}
