package org.mulesoft.apb.project.client.scala.model.descriptor.governance

import amf.core.client.scala.model.IntField
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Type.Int
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}
import amf.core.internal.metamodel.Field
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.StatusModel.{
  Errors,
  Info,
  Warning,
  entityModel
}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Governance

class Status(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = Status

  override protected def fields: Fields = internal.fields

  def errors: Option[Int]  = get[IntField](Errors)
  def warning: Option[Int] = get[IntField](Warning)
  def info: Option[Int]    = get[IntField](Info)

  def withErrors(errors: Int): this.type = {
    internal.withProperty(Errors, errors)
    this
  }

  def withWarning(warning: Int): this.type = {
    internal.withProperty(Warning, warning)
    this
  }

  def withInfo(info: Int): this.type = {
    internal.withProperty(Info, info)
    this
  }

}

object Status {
  def apply(errors: Int, warning: Int, info: Int): Status =
    Status
      .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
      .withErrors(errors)
      .withWarning(warning)
      .withInfo(info)

  private[apb] def apply(jsonLDObject: JsonLDObject): Status = new Status(jsonLDObject)

}

trait StatusModel {
  val Errors: Field  = Field(Int, Governance + "errors", doc("errors"))
  val Warning: Field = Field(Int, Governance + "warning", doc("warning"))
  val Info: Field    = Field(Int, Governance + "info", doc("info"))

  val `type`: List[ValueType] = List(Governance + "Status")
  val fields: List[Field]     = List(Errors, Warning, Info)

  protected def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)

}

object StatusModel extends StatusModel
