package org.mulesoft.apb.project.client.platform.model.descriptor.community

import amf.apicontract.internal.convert.ApiClientConverters.ClientOption
import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.{Community => InternalCommunity}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import org.mulesoft.common.time.SimpleDateTime

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class Community private[apb] (override private[apb] val _internal: InternalCommunity)
    extends DynamicObject(_internal) {

  @JSExportTopLevel("Community")
  def this(portal: String, target: PortalTarget, profiles: ClientList[CommunityProfile], createdAt: SimpleDateTime) =
    this(InternalCommunity(portal, target._internal, profiles.asInternal, createdAt))

  def portal(): String                         = _internal.portal
  def version(): ClientOption[String]          = _internal.version.asClient
  def profiles(): ClientList[CommunityProfile] = _internal.profiles.asClient
  def target(): PortalTarget                   = _internal.target
  def createdAt(): String                      = _internal.createdAt.toString()

  def withPortal(portal: String): Community = {
    _internal.withPortal(portal)
    this
  }

  def withVersion(version: String): Community = {
    _internal.withVersion(version)
    this
  }

  def withProfiles(profiles: ClientList[CommunityProfile]): Community = {
    _internal.withProfiles(profiles.asInternal)
    this
  }

  def withTarget(target: PortalTarget): Community = {
    _internal.withTarget(target)
    this
  }

  def withCreatedAt(createdAt: SimpleDateTime): Community = {
    _internal.withCreatedAt(createdAt)
    this
  }
}
