package org.mulesoft.apb.client.platform
import amf.apicontract.client.platform.AMFConfiguration
import amf.core.client.platform.{AMFParseResult, AMFResult}
import amf.core.client.platform.validation.{AMFValidationReport, AMFValidationResult}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.client.platform.environment.DependencyFetcher
import org.mulesoft.apb.client.scala.model.Gav
import org.mulesoft.apb.client.scala.{APBClient => InternalAPBClient}

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class APBClient(private[apb] val _internal: InternalAPBClient) {

  val projectConfiguration: ClientFuture[ProjectConfiguration] = _internal.projectConfiguration.asClient

  def getAMFConfiguration: ClientFuture[AMFConfiguration] = _internal.getAMFConfiguration.asClient

  def compile(): ClientFuture[AMFParseResult] = _internal.compile().asClient

  def build(): ClientFuture[AMFResult] = _internal.build().asClient

  def report(): ClientFuture[AMFValidationReport] = _internal.report().asClient

  def checkTree(): ClientFuture[ClientList[AMFValidationResult]] = _internal.checkTree().asClient

  lazy val listDependencies: ClientFuture[ClientList[Gav]] = _internal.listDependencies.asClient
}

@JSExportAll
@JSExportTopLevel("APBClient")
object APBClient {
  def fromContent(content: String, dependencyFetcher: DependencyFetcher): APBClient = {
    InternalAPBClient.fromContent(content, DependencyFetcherConverter.asInternal(dependencyFetcher), None)
  }

  def fromDirectory(file: String, dependencyFetcher: DependencyFetcher): ClientFuture[APBClient] = {
    InternalAPBClient.fromDirectory(file, dependencyFetcher).asClient
  }

}
