package org.mulesoft.apb.client.platform
import amf.apicontract.client.platform.AMFConfiguration
import org.mulesoft.apb.client.scala.dependency.{ProjectConfiguration => InternalProjectConfiguration}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import amf.core.client.platform.execution.ExecutionEnvironment
import amf.core.internal.remote.Spec
import org.mulesoft.apb.client.platform.dependency.ParsedDependency

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class ProjectConfiguration private[apb] (private[apb] val _internal: InternalProjectConfiguration) {

  private[apb] lazy val parseConfig: AMFConfiguration = _internal.parseConfig

  def configFor(spec: Spec): AMFConfiguration = _internal.configFor(spec)

  val allDependencies: ClientList[ParsedDependency] = _internal.allDependencies.asClient
}
