package org.mulesoft.apb.client.platform.model

import org.mulesoft.apb.client.scala.model.{Gav, ProjectDependency}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.client.scala.model.{ProjectDescriptor => InternalProjectDescriptor}

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class ProjectDescriptor private[apb] (private[apb] val _internal: InternalProjectDescriptor) {
  val main: String                                = _internal.main
  val name: String                                = _internal.name
  val gav: Gav                                    = _internal.gav
  val classifier: ClientOption[String]            = _internal.classifier.asClient
  val tags: ClientList[String]                    = _internal.tags.asClient
  val dependencies: ClientList[ProjectDependency] = _internal.dependencies.asClient
}
