package org.mulesoft.apb.client.scala

import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.client.scala.APBClient.platform
import org.mulesoft.apb.client.scala.dependency.{APBUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.internal.parser.APBEnv

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class APBClientBuilder(private val dependencyFetcher: DependencyFetcher) extends PlatformSecrets {

  private var resourceLoaders                     = platform.loaders().toList
  private var unitsCacheBuilder: UnitCacheBuilder = APBUnitCacheBuilder

  def withCacheBuilder(builder: UnitCacheBuilder): this.type = {
    this.unitsCacheBuilder = builder
    this
  }

  def withResourceLoaders(loaders: List[ResourceLoader]): this.type = {
    this.resourceLoaders = loaders
    this
  }

  def build(directory: String): Future[APBClient] = {
    val eventualContent = fetchDescriptorFile(directory)
    eventualContent.map(c => build(c.stream.toString, Some(directory)))
  }

  def build(descriptorAsString: String, directory: Option[String]): APBClient = {
    val descriptor = APBEnv.getParser(descriptorAsString).parse(directory)
    new APBClient(descriptor, dependencyFetcher, unitsCacheBuilder, resourceLoaders)
  }

  private def fetchDescriptorFile(directory: String) = {
    val config = AMFGraphConfiguration.empty().withResourceLoaders(resourceLoaders)
    platform.fetchContent(directory + "/" + APBEnv.descriptorFileName, config)
  }
}
