package org.mulesoft.apb.client.scala.environment

import amf.core.client.common.remote.Content
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.client.scala.dependency.{ExchangeModulePathHandler, ModuleNotFoundException}

import scala.concurrent.Future
import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

trait DependencyFetcher {

  final def wrapFetch(groupId: String, assetId: String, version: String, protocol: String): ResourceLoader = {
    val inner: ResourceLoader = fetch(groupId, assetId, version)
    new ResourceLoader {

      /** Fetch specified resource and return associated content. Resource should have been previously accepted.
        * If the resource doesn't exists, it returns a failed future caused by a ResourceNotFound exception. */
      override def fetch(resource: String): Future[Content] = {
        inner.fetch(resource).map { c =>
          val path = ExchangeModulePathHandler.buildPath(groupId, assetId, version, resource, protocol)
          c.copy(url = path)
        }
      }

      /** Checks if the resource loader accepts the specified resource. */
      override def accepts(resource: String): Boolean = inner.accepts(resource)
    }

  }

  def accepts(groupId: String, assetId: String, version: String): Boolean
  def fetch(groupId: String, assetId: String, version: String): ResourceLoader
}

@JSExportAll
@JSExportTopLevel("UnreachableGavError")
case class UnreachableGavException(message: String) extends Exception(message)
