package org.mulesoft.apb.internal

import amf.core.internal.parser.YMapOps
import org.yaml.model.YMap

package object parser {
  implicit class YMapLocalOps(map: YMap) extends YMapOps(map) {
    def stringValueFor(keyword: String, fn: String => Unit): Unit = {
      stringValueFor(keyword) foreach { fn }
    }

    def stringValueFor(keyword: String): Option[String] = {
      key(keyword).flatMap { e =>
        e.value.asScalar.map(_.text)
      }
    }
  }
}
