package org.mulesoft.apb.client.scala

import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.client.scala.ProjectBuilder
import org.mulesoft.apb.project.client.scala.dependency.{APBUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.internal.parser.APBEnv

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class APBClientBuilder(private val dependencyFetcher: DependencyFetcher) extends PlatformSecrets {

  private var resourceLoaders                     = platform.loaders().toList
  private var unitsCacheBuilder: UnitCacheBuilder = APBUnitCacheBuilder

  def withCacheBuilder(builder: UnitCacheBuilder): this.type = {
    this.unitsCacheBuilder = builder
    this
  }

  def withResourceLoaders(loaders: List[ResourceLoader]): this.type = {
    this.resourceLoaders = loaders
    this
  }

  def build(directory: String): Future[APBClient] =
    getProjectBuilder.buildFromDirectory(directory).map(pc => new APBClient(pc))

  def build(descriptorAsString: String, directory: Option[String]): Future[APBClient] =
    getProjectBuilder.buildFromContent(descriptorAsString, directory).map(pc => new APBClient(pc))

  private def getProjectBuilder = new ProjectBuilder(dependencyFetcher, resourceLoaders, unitsCacheBuilder)

}
