package org.mulesoft.apb.client.platform

import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.client.scala.{APBClientBuilder => InternalAPBClientBuilder}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher
import org.mulesoft.apb.project.client.platform.model.ProjectDescriptor

import scala.concurrent.ExecutionContext
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class APBClientBuilder private[apb] (private val internal: InternalAPBClientBuilder) {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global

  @JSExportTopLevel("APBClientBuilder")
  def this(fetcher: DependencyFetcher) {
    this(InternalAPBClientBuilder(fetcher))
  }

  def withResourceLoaders(loaders: ClientList[ResourceLoader]): this.type = {
    internal.withResourceLoaders(loaders.asInternal.toList)
    this
  }

  def build(directory: String): ClientFuture[APBClient] = internal.build(directory).asClient

  def build(descriptorAsString: String, directory: ClientOption[String]): ClientFuture[APBClient] =
    internal.build(descriptorAsString, ClientOptionOps(directory).toScala).asClient

  def build(descriptor: ProjectDescriptor): ClientFuture[APBClient] = internal.build(descriptor).asClient
}
