package org.mulesoft.apb.client.platform.model

import amf.apicontract.client.scala.model.domain.api.Api
import amf.core.client.platform.model.document.{BaseUnit, EncodesModel}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.client.scala.model.{Project => InternalProject, ProjectDocument => InternalProjectDocument}
import org.mulesoft.apb.internal.convert.APBClientConverters._

class ProjectDocument(private[apb] val _internal: InternalProjectDocument) {

  def this() = this(InternalProjectDocument())

  /** Encoded DomainElement described in the document element. */
  def encodes: ProjectInfo = _internal.encodes

}

case class Project(private[apb] val _internal: InternalProject) {

  def apiContract(): Api = _internal.apiContract()
  def instances(): ClientList[JsonLDObject] = {
    new InternalSeqOps(_internal.instances())(new IdentityMatcher[JsonLDObject] {}).asClient
  }

  // TODO native-jsonld : add properties of the descriptor
}
