package org.mulesoft.apb.client.scala

import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.client.scala.ProjectBuilder
import org.mulesoft.apb.project.client.scala.dependency.{APBUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class ApiContractClientBuilder(private val dependencyFetcher: DependencyFetcher) extends PlatformSecrets {

  private var resourceLoaders                     = platform.loaders().toList
  private var unitsCacheBuilder: UnitCacheBuilder = APBUnitCacheBuilder

  def withCacheBuilder(builder: UnitCacheBuilder): this.type = {
    this.unitsCacheBuilder = builder
    this
  }

  def withResourceLoaders(loaders: List[ResourceLoader]): this.type = {
    this.resourceLoaders = loaders
    this
  }

  def withResourceLoader(loader: ResourceLoader): this.type = {
    this.resourceLoaders = loader +: this.resourceLoaders
    this
  }
  def build(directory: String): Future[ApiContractClient] =
    getProjectBuilder.buildFromDirectory(directory).map(new ApiContractClient(_))

  def build(descriptor: ProjectDescriptor): Future[ApiContractClient] =
    getProjectBuilder.build(descriptor).map(new ApiContractClient(_))

  def buildFromContent(descriptorAsString: String, directory: Option[String]): Future[ApiContractClient] =
    getProjectBuilder.buildFromContent(descriptorAsString, directory).map(new ApiContractClient(_))

  private def getProjectBuilder =
    new ProjectBuilder(dependencyFetcher, resourceLoaders, unitsCacheBuilder)

}
