package org.mulesoft.apb.client.scala.model

import amf.apicontract.client.scala.model.domain.api.Api
import amf.core.client.scala.model.{IntField, StrField}
import amf.core.client.scala.model.domain.DomainElement
import amf.core.internal.metamodel.Obj
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel.{
  ApiContract,
  Categories,
  CreatedAt,
  CreatedBy,
  Instances,
  KeyValueTags,
  MajorVersionComponent,
  MinorVersionComponent,
  PatchVersionComponent,
  Status,
  Tags,
  TenantId
}
import org.mulesoft.apb.project.client.scala.model.ProjectDependency
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{AssetId, GroupId, Version}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel.{Dependencies, OrganizationId}

class ProjectInfo(override val fields: Fields, override val annotations: Annotations) extends DomainElement {
  override def meta: Obj = ProjectInfoModel

  def apiContract(): Api              = fields.field(ApiContract)
  def instances(): List[JsonLDObject] = fields.field(Instances)

  def groupId(): StrField = fields.field(GroupId)
  def assetId(): StrField = fields.field(AssetId)
  def version(): StrField = fields.field(Version)

  def organizationId(): StrField = fields.field(OrganizationId)

  def tenantId(): StrField           = fields.field(TenantId)
  def tags(): List[StrField]         = fields.field(Tags)
  def keyValueTags(): List[StrField] = fields.field(KeyValueTags)
  def categories(): List[StrField]   = fields.field(Categories)

  def majorVersionComponent(): IntField = fields.field(MajorVersionComponent)
  def minorVersionComponent(): IntField = fields.field(MinorVersionComponent)

  def patchVersionComponent(): IntField = fields.field(PatchVersionComponent)

  def status(): StrField = fields.field(Status)

  def createdBy(): StrField = fields.field(CreatedBy)

  def createdAt(): StrField = fields.field(CreatedAt)

  def dependencies(): List[ProjectDependency] = fields.field(Dependencies)

  override def componentId: String = "projectInfo"
}

object ProjectInfo {
  def apply() = new ProjectInfo(Fields(), Annotations())
}
