package org.mulesoft.apb.internal.metamodel

import amf.apicontract.internal.metamodel.domain.api.BaseApiModel
import amf.core.client.scala.model.domain.AmfObject
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Type.{DateTime, Str}
import amf.core.internal.metamodel.domain.{DomainElementModel, ModelDoc, ModelVocabularies}
import amf.core.internal.metamodel.{Field, Type}
import org.mulesoft.apb.client.scala.model.ProjectInfo
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{AssetId, GroupId, Version}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel._
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Catalog, Core}

object ProjectInfoModel extends DomainElementModel {
  override def modelInstance: AmfObject = ProjectInfo()

  val ApiContract: Field = Field(
      BaseApiModel,
      APBNamespace.Project + "apiContract",
      ModelDoc(
          ModelVocabularies.AmlDoc,
          "apiContract",
          "Documentation spec for this particular API project"
      )
  )

  val Instances: Field = Field(
      Type.Array(DomainElementModel),
      APBNamespace.Project + "apiInstances",
      ModelDoc(
          ModelVocabularies.AmlDoc,
          "apiInstances",
          "Instances related to this API project"
      )
  )

  val CustomFields: Field = Field(
      Type.Array(Str),
      Catalog + "customFields",
      ModelDoc(
          ModelVocabularies.AmlDoc,
          "customFields",
          ""
      )
  )

  val Categories: Field = Field(
      Type.Array(Str),
      Catalog + "categories",
      ModelDoc(
          ModelVocabularies.AmlDoc,
          "categories",
          ""
      )
  )

  val Tags: Field = Field(
      Type.Array(Str),
      Catalog + "tags"
  )

  val KeyValueTags: Field = Field(
      Type.Array(Str),
      Catalog + "keyValueTags"
  )

  val CreatedBy: Field = Field(
      Str,
      Anypoint + "userId"
  )

  val CreatedAt: Field = Field(
      DateTime,
      Core + "dateCreated"
  )

  val Status: Field = Field(
      Str,
      Catalog + "status"
  )

  val TenantId: Field = Field(
      Str,
      Anypoint + "tenantId"
  )

  val MajorVersionComponent: Field = Field(
      Type.Int,
      Catalog + "majorVersionComponent"
  )

  val MinorVersionComponent: Field = Field(
      Type.Int,
      Catalog + "minorVersionComponent"
  )

  val PatchVersionComponent: Field = Field(
      Type.Int,
      Catalog + "patchVersionComponent"
  )

  override def fields: List[Field] =
    List(
        ApiContract,
        Instances,
        GroupId,
        AssetId,
        Version,
        OrganizationId,
        Dependencies,
        CustomFields,
        Categories,
        Tags,
        KeyValueTags,
        CreatedBy,
        CreatedAt,
        Status,
        TenantId,
        MajorVersionComponent,
        MinorVersionComponent,
        PatchVersionComponent
    ) ++ DomainElementModel.fields

  override val `type`: List[ValueType] = List(APBNamespace.Project + "ProjectInfo") ++ DomainElementModel.`type`
}
