package org.mulesoft.apb.client.platform

import amf.apicontract.client.platform.AMFConfiguration
import amf.core.client.platform.validation.{AMFValidationReport, AMFValidationResult}
import amf.core.client.platform.{AMFParseResult, AMFResult}
import org.mulesoft.apb.client.scala.{ApiContractClient => InternalAPBClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.ProjectConfiguration
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher
import org.mulesoft.apb.project.client.platform.model.{Gav, ProjectDescriptor}

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class ApiContractClient private[apb](private[apb] val _internal: InternalAPBClient) {

  val projectConfiguration: ProjectConfiguration = _internal.projectConfiguration

  def getAMFConfiguration: AMFConfiguration = _internal.getAMFConfiguration

  def compile(): ClientFuture[AMFParseResult] = _internal.compile().asClient

  def build(): ClientFuture[AMFResult] = _internal.build().asClient

  def report(): ClientFuture[AMFValidationReport] = _internal.report().asClient

  def lint(): ClientFuture[AMFValidationReport] = _internal.lint().asClient

  def checkTree(): ClientList[AMFValidationResult] = _internal.checkTree().asClient

  lazy val listDependencies: ClientList[Gav] = _internal.listDependencies.asClient
}
