package org.mulesoft.apb.client.scala

import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor

class APIProjectClientBuilder(descriptor: ProjectDescriptor, dependencyFetcher: DependencyFetcher) {

  private var loader: Option[ResourceLoader]  = None
  private var cache: Option[ProjectNodeCache] = None

  def withResourceLoader(loader: ResourceLoader): APIProjectClientBuilder = {
    this.loader = Some(loader)
    this
  }

  def withCache(cache: ProjectNodeCache): APIProjectClientBuilder = {
    this.cache = Some(cache)
    this
  }

  def build(): APIProjectClient = new APIProjectClient(descriptor, dependencyFetcher, loader, cache)
}
