package org.mulesoft.apb.internal.convert

import amf.apicontract.client.scala.model.domain.api.Api
import amf.core.client.scala.AMFResult
import amf.core.client.scala.model.document.Document
import amf.core.client.scala.model.domain.DomainElement
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject

object ElementConverters {

  case class UnmetClassExpectationError() extends Exception("Expected class of a specific type but found another")
  case class ApiWithoutEncodesError()     extends Exception("Parsed API doesn't have an encoded element")
  implicit class DomainElementConverter(d: DomainElement) {

    def as[T <: DomainElement]: T = d match {
      case t: T => t
      case _    => throw UnmetClassExpectationError()
    }

    def toApi(): Api = as[Api]

    def toJsonLDObject(): JsonLDObject = as[JsonLDObject]
  }

  implicit class AMFResultConverter(r: AMFResult) {
    def encodedElement(): DomainElement = r.baseUnit match {
      case d: Document => d.encodes
      case _           => throw ApiWithoutEncodesError()
    }
  }

}
