package org.mulesoft.apb.client.platform

import amf.core.client.platform.model.domain.DomainElement
import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.client.scala.{APIInstanceClient => InternalAPIInstanceClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._

import scala.concurrent.ExecutionContext
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
@JSExportAll
class APIInstanceClient private[apb] (private[apb] val _internal: InternalAPIInstanceClient) {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global
  def build(): ClientFuture[DomainElement]                = _internal.build().asClient
}

@JSExportAll
@JSExportTopLevel("APIInstanceClient")
object APIInstanceClient {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global
  def build(instance: String, rl: ResourceLoader): ClientFuture[DomainElement] =
    InternalAPIInstanceClient.build(instance, ResourceLoaderMatcher.asInternal(rl)).asClient
}
