package org.mulesoft.apb.client.scala.model

import amf.apicontract.client.scala.model.domain.api.Api
import amf.core.client.scala.model.document.{BaseUnit, EncodesModel}
import amf.core.internal.adoption.IdAdopter
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.document.BaseUnitModel
import amf.core.internal.metamodel.document.DocumentModel.Encodes
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.{JsonLDArray, JsonLDObject}
import org.mulesoft.apb.client.scala.extensions.APIProjectExtension
import org.mulesoft.apb.internal.metamodel.ProjectDocumentModel
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel.{Contract, Instances}
import org.mulesoft.apb.internal.view.ProjectView
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel.{
  MajorVersionComponent,
  MinorVersionComponent,
  PatchVersionComponent
}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Management

class ProjectDocument(override val fields: Fields, override val annotations: Annotations)
    extends BaseUnit
    with EncodesModel {

  /** Meta data for the document */
  override def meta: BaseUnitModel = ProjectDocumentModel

  /** Returns the list document URIs referenced from the document that has been parsed to generate this model */
  override def references: Seq[BaseUnit] = Nil

  /** Encoded DomainElement described in the document element. */
  override def encodes: ProjectInfo = fields(Encodes)

  /** Value , path + field value that is used to compose the id when the object its adopted */
  override def componentId: String = "project"
}

object ProjectDocument {
  def apply() = new ProjectDocument(Fields(), Annotations())
}

case class Project(private[apb] val document: ProjectDocument) {

  private[apb] def projectInfo       = document.encodes
  def apiContract(): Api             = projectInfo.apiContract()
  def instances(): Seq[JsonLDObject] = projectInfo.instances()

  // TODO native-jsonld : add properties of the descriptor
}

object ProjectBuilder {
  val INSTANCE_ID_IRI: Field = Field(Str, Management + "instanceID")
}

case class ProjectBuilder(descriptor: ProjectDescriptor) {
  private val projectInfo                           = ProjectInfo()
  private val projectDocument                       = ProjectDocument().set(Encodes, projectInfo)
  private var extensions: List[APIProjectExtension] = List.empty

  def withContract(api: Api): ProjectBuilder = {
    projectInfo.set(Contract, api)
    this
  }

  def withInstances(instances: List[JsonLDObject]): ProjectBuilder = {
    val arr = new JsonLDArray()
    instances.foreach(arr += _)
    projectInfo.set(Instances, arr)
    this
  }

  def withExtensions(extensions: List[APIProjectExtension]) = {
    this.extensions = extensions
    this
  }
  def build(): Project = {
    addFieldsFromDescriptor(projectInfo, descriptor)
    val project = Project(projectDocument)
    extensions.foreach(extension => extension.extend(project))
    new IdAdopter(projectDocument, "http://project.aml#").adoptFromRoot()
    project
  }

  private def addFieldsFromDescriptor(projectInfo: ProjectInfo, descriptor: ProjectDescriptor) = {
    ProjectView(projectInfo).view(descriptor.wrapped)
  }
}
