package org.mulesoft.apb.internal.convert

import amf.core.client.scala.model.domain.{DomainElement => InternalDomainElement}
import amf.core.client.platform.model.domain.DomainElement
import amf.core.internal.convert.{ClientInternalMatcher, InternalClientMatcher}
import org.mulesoft.apb.client.platform.{
  ClientProjectNodeCache,
  ApiContractClient => ClientAPBClient,
  APIInstanceClient => ClientAPIInstanceClient,
  APIProjectClient => ClientAPIProjectClient
}
import org.mulesoft.apb.client.scala.{ApiContractClient, APIInstanceClient, APIProjectClient, ProjectNodeCache}
import org.mulesoft.apb.client.scala.model.{Project, ProjectDocument, ProjectInfo}
import org.mulesoft.apb.client.platform.model.{
  Project => ClientProject,
  ProjectDocument => ClientProjectDocument,
  ProjectInfo => ClientProjectInfo
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters

import java.util.concurrent.CompletableFuture
import scala.concurrent.Future
import scala.concurrent.ExecutionContext.Implicits.global
object APBClientConverters extends APBProjectConverters {

  implicit object APBClientClientConverter extends InternalClientMatcher[ApiContractClient, ClientAPBClient] {
    override def asClient(from: ApiContractClient): ClientAPBClient = new ClientAPBClient(from)
  }

  implicit object APBProjectConverter extends InternalClientMatcher[Project, ClientProject] {
    override def asClient(from: Project): ClientProject = new ClientProject(from)
  }

  implicit object APBProjectInfoConverter extends InternalClientMatcher[ProjectInfo, ClientProjectInfo] {
    override def asClient(from: ProjectInfo): ClientProjectInfo = new ClientProjectInfo(from)
  }

  implicit object APBProjectDocumentConverter extends InternalClientMatcher[ProjectDocument, ClientProjectDocument] {
    override def asClient(from: ProjectDocument): ClientProjectDocument = new ClientProjectDocument(from)
  }

  implicit object APBAPIInstanceClientConverter
      extends InternalClientMatcher[APIInstanceClient, ClientAPIInstanceClient] {
    override def asClient(from: APIInstanceClient): ClientAPIInstanceClient = new ClientAPIInstanceClient(from)
  }

  implicit object APBProjectClientConverter extends InternalClientMatcher[APIProjectClient, ClientAPIProjectClient] {
    override def asClient(from: APIProjectClient): ClientAPIProjectClient = new ClientAPIProjectClient(from)
  }

  implicit object APBClientProjectNodeCache extends ClientInternalMatcher[ClientProjectNodeCache, ProjectNodeCache] {
    override def asInternal(from: ClientProjectNodeCache): ProjectNodeCache = new ProjectNodeCache {
      override def fetch(uri: String): Option[Future[InternalDomainElement]] =
        toScalaOption(from.fetch(uri)).map(client => {
          asInternalFuture(client, DomainElementMatcher)
        })
    }
  }
}
