package org.mulesoft.apb.internal.gcl

import amf.core.client.scala.model.domain.DomainElement
import amf.shapes.client.scala.model.domain.SemanticContext
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject

case class ApiInstanceQuery(instance: JsonLDObject) {

  private val METADATA_IRI       = SemanticContext.baseIri + "metadata"
  private val LABELS_IRI         = SemanticContext.baseIri + "metadata/labels"
  private val INSTANCE_ID_IRI    = SemanticContext.baseIri + "metadata/labels/mulesoft.com/apiinstance-id"
  private val ENVIRONMENT_ID_IRI = SemanticContext.baseIri + "metadata/labels/mulesoft.com/environment-id"

  def instanceId(): Option[String]    = labels().flatMap(string(INSTANCE_ID_IRI))
  def environmentId(): Option[String] = labels().flatMap(string(ENVIRONMENT_ID_IRI))

  private def labels(): Option[DomainElement] = obj(METADATA_IRI)(instance).flatMap(obj(LABELS_IRI))

  private def obj(iri: String)(elem: DomainElement)    = elem.graph.getObjectByProperty(iri).headOption
  private def string(iri: String)(elem: DomainElement) = elem.graph.scalarByProperty(iri).headOption.map(_.toString)
}
