package org.mulesoft.apb.internal.view

import amf.core.client.scala.model.domain.{AmfArray, AmfElement, AmfObject, DomainElement}
import amf.core.internal.metamodel.Field
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.internal.view.Views.View

trait ModelView[T] {
  def view(element: DomainElement): T
}

case class CustomizableModelView(views: List[View], copier: DomainElementCopier) extends ModelView[DomainElement] {

  private def filters = views.toMap

  def view(project: DomainElement): DomainElement = {
    createView(project)
  }

  private def createView(project: DomainElement): DomainElement = {
    val summary = copier.copy(project)
    createView(project, summary)
  }

  private def createView[T <: AmfObject](origin: AmfObject, view: T): T = {
    val fields = fieldViewsFor(origin)
    fields.foldLeft(view) { (result, field) =>
      find(origin, field)
        .map { value =>
          val next = traverse(value, shallowCopy(value))
          result.set(field, next)
        }
        .getOrElse(result)
    }
  }

  private def fieldViewsFor[T <: AmfObject](origin: AmfObject) = {
    origin.meta.`type`.flatMap(filters.get).flatten
  }

  private def shallowCopy(element: AmfElement): AmfElement = element match {
    case obj: DomainElement => copier.copy(obj)
    case obj: JsonLDObject  => copier.copy(JsonLDObject.empty(obj.model, obj.path))
    case array: AmfArray    => AmfArray(array.values.map(x => shallowCopy(x)))
    case other              => other
  }

  private def traverse(origin: AmfElement, view: AmfElement): AmfElement = {
    (origin, view) match {
      case (originObj: AmfObject, viewObj: AmfObject) => createView(originObj, viewObj)
      case (originArr: AmfArray, viewArr: AmfArray) =>
        originArr.values.zip(viewArr.values).foreach(traverse)
        viewArr
      case _ => view
    }
  }

  private def traverse(tuple: (AmfElement, AmfElement)): AmfElement = traverse(tuple._1, tuple._2)

  private def find(element: AmfObject, field: Field) = {
    element.fields.getValueAsOption(field).map(_.value)
  }
}
