package org.mulesoft.apb.internal.view

import amf.core.client.scala.model.domain.DomainElement
import org.mulesoft.apb.client.scala.model.ProjectInfo
import org.mulesoft.apb.internal.view.Views.descriptorView

object ProjectView {
  def apply(project: ProjectInfo): ModelView[ProjectInfo] = {
    ProjectInfoView(project, CustomizableModelView(descriptorView, AsIsElementCopier))
  }
}

case class ProjectInfoView(project: ProjectInfo, inner: ModelView[DomainElement]) extends ModelView[ProjectInfo] {
  override def view(element: DomainElement): ProjectInfo = {
    val copy = inner.view(element)
    copy.fields.into(project.fields)
    project
  }
}
