package org.mulesoft.apb.internal.loaders

import amf.core.client.common.remote.Content
import amf.core.client.scala.resource.ResourceLoader

import scala.concurrent.Future

object NestedDocumentRL extends ResourceLoader {

  /** Fetch specified resource and return associated content. Resource should have been previously accepted. If the
    * resource doesn't exists, it returns a failed future caused by a ResourceNotFound exception.
    */
  override def fetch(resource: String): Future[Content] = Future.successful(new Content(resource, resource))

  /** Checks if the resource loader accepts the specified resource. */
  override def accepts(resource: String): Boolean = true
}
