package org.mulesoft.apb.client.platform

import amf.core.client.platform.model.document.BaseUnit
import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.client.scala.{APIInstanceClient => InternalAPIInstanceClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.model.management.APIInstance

import scala.concurrent.ExecutionContext
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
@JSExportAll
class APIInstanceClient private[apb] (private[apb] val _internal: InternalAPIInstanceClient) {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global
  def build(): ClientFuture[BaseUnit]                     = _internal.build().map(_.result).asClient
}

@JSExportAll
@JSExportTopLevel("APIInstanceClient")
object APIInstanceClient {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global
  def build(instance: String, rl: ResourceLoader): ClientFuture[BaseUnit] =
    InternalAPIInstanceClient.build(instance, ResourceLoaderMatcher.asInternal(rl)).map(_.result).asClient
}
