package org.mulesoft.apb.internal.generated

object Common {

  def schema: String = """{
                          |  "$schema": "https://json-schema.org/draft-07/schema",
                          |  "$comment": "Common elements to all definitions",
                          |  "$id": "http://gateway.mulesoft.com/v1alpha1/commons",
                          |  "definitions": {
                          |    "Metadata": {
                          |      "type": "object",
                          |      "properties": {
                          |        "name": {
                          |          "type": "string"
                          |        },
                          |        "labels": {
                          |          "type": "object",
                          |          "properties": {
                          |            "mulesoft.com/apiinstance-id": {
                          |              "type": "integer"
                          |            },
                          |            "mulesoft.com/apiinstance-label": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-name": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/environment-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/organization-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-group-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-asset-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-asset-name": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-version": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/definition-groupId": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/definition-assetId": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/definition-version": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/implementation-groupId": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/implementation-assetId": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/implementation-version": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/definition-template-id": {
                          |              "type": "string"
                          |            },
                          |            "aws.amazon.com/account": {
                          |              "type": "string",
                          |              "description": "Aws origin account of the mapped api instance"
                          |            },
                          |            "aws.amazon.com/resource-type": {
                          |              "type": "string",
                          |              "description": "Aws resource type",
                          |              "enum": ["HTTP", "REST", "stage"]
                          |            },
                          |            "aws.amazon.com/instance-id": {
                          |              "type": "string",
                          |              "description": "Aws id of the mapped gateway"
                          |            },
                          |            "aws.amazon.com/region": {
                          |              "type": "string",
                          |              "description": "AWS region where the api instance is deployed"
                          |            },
                          |            "mulesoft.com/third-party-source": {
                          |              "type": "string",
                          |              "description": "Source where this api instance is mapped from",
                          |              "enum": ["aws"]
                          |            }
                          |          }
                          |        },
                          |        "annotations": {
                          |          "type": "object",
                          |          "properties": {
                          |            "mulesoft.com/apiinstance-deprecated": {
                          |              "type": "boolean"
                          |            },
                          |            "mulesoft.com/apiinstance-deployment-target": {
                          |              "type": ["string", "null"],
                          |              "enum": ["CH", "HY", "RTF", null]
                          |            },
                          |            "mulesoft.com/apiinstance-deployment-runtime-version": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-deployment-technology": {
                          |              "type": "string",
                          |              "enum": ["mule4", "mule3", "flexGateway", "serviceMesh"]
                          |            },
                          |            "aws.amazon.com/arn": {
                          |              "type": "string",
                          |              "description": "aws unique resource identifier from where the instance is mapped from"
                          |            },
                          |            "mulesoft.com/third-party-href": {
                          |              "type": "string",
                          |              "description": "Link to third party api instance console"
                          |            },
                          |            "mulesoft.com/third-party-label": {
                          |              "type": "string",
                          |              "description": "Description of the third party api instance console"
                          |            }
                          |          }
                          |        }
                          |      },
                          |      "required": [
                          |        "name"
                          |      ]
                          |    }
                          |  }
                          |}""".stripMargin
}
