package org.mulesoft.apb.internal.gcl

import amf.shapes.client.scala.model.document.JsonSchemaDocument
import org.mulesoft.apb.internal.generated.{
  ApiInstanceSchema,
  Common,
  EnvironmentBindingSchema,
  EnvironmentSchema,
  ExtensionSchema,
  PolicyBindingSchema,
  ServiceSchema
}
import org.mulesoft.apb.project.internal.instances.ResourceKind.{
  ApiInstance,
  Environment,
  EnvironmentBinding,
  Extension,
  PolicyBinding,
  Service
}
import org.mulesoft.apb.project.internal.parser.SyncJsonSchemaCompiler

object SchemaProvider {

  def get(kind: String): Option[String] = schemas.get(kind)

  def all = schemas

  lazy val extensionSchema =
    SyncJsonSchemaCompiler.compile(ExtensionSchema.schema).baseUnit.asInstanceOf[JsonSchemaDocument]

  def extensions(): Map[String, String] = Map(
      Extension.kind -> ExtensionSchema.schema
  )

  private val schemas: Map[String, String] = Map(
      ApiInstance.kind        -> ApiInstanceSchema.schema,
      EnvironmentBinding.kind -> EnvironmentBindingSchema.schema,
      Environment.kind        -> EnvironmentSchema.schema,
      Extension.kind          -> ExtensionSchema.schema,
      PolicyBinding.kind      -> PolicyBindingSchema.schema,
      Service.kind            -> ServiceSchema.schema,
      "commons.json"          -> Common.schema
  )
}
