package org.mulesoft.apb.internal.view

import amf.core.client.scala.vocabulary.{Namespace, ValueType}
import amf.core.internal.metamodel.Field
import org.mulesoft.apb.client.scala.extensions.EnvironmentExtension.ENVIRONMENT_IRI
import org.mulesoft.apb.client.scala.extensions.InstanceEnvironmentModel
import org.mulesoft.apb.client.scala.model.ProjectBuilder.INSTANCE_ID_IRI
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel._
import org.mulesoft.apb.project.client.scala.instances.APIInstanceBuilder.API_INSTANCE_TERM
import org.mulesoft.apb.project.client.scala.model.{InstanceModel, ProjectDependencyModel, ProjectDescriptorModel}
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{AssetId, GroupId, Scope, Version}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel._

object Views {

  type View = (ValueType, List[Field])

  private val projectView = ProjectInfoModel.`type`.head -> List(
      OrganizationId,
      Classifier,
      GroupId,
      AssetId,
      Version,
      MajorVersionComponent,
      MinorVersionComponent,
      PatchVersionComponent,
      Status,
      Tags,
      Categories,
      Instances,
      Dependencies
  )

  private val apiInstanceView = API_INSTANCE_TERM -> List(
      INSTANCE_ID_IRI,
      ENVIRONMENT_IRI
  )

  private val dependencyView = ProjectDependencyModel.`type`.head -> List(
      GroupId,
      AssetId,
      Version,
      Scope
  )

  private val environmentView = InstanceEnvironmentModel.`type`.head -> InstanceEnvironmentModel.fields

  private val instancesDescriptorView = InstanceModel.`type`.head -> InstanceModel.fields
  val projectSummary: List[View]      = List(projectView, apiInstanceView, environmentView, dependencyView)
  private val descriptorFieldsView =
    ProjectDescriptorModel.`type`.head -> ProjectInfoModel.fields.filter(_ != Instances)
  val descriptorView: List[View] = List(descriptorFieldsView, dependencyView, instancesDescriptorView)

  def mappings(schemaId: String) = {

    def valueType = (entity: String) => ValueType(Namespace(schemaId), s"#/declarations/${entity}")
    Map(
        ProjectInfoModel.`type`.head         -> List(valueType("APIProject")),
        InstanceEnvironmentModel.`type`.head -> List(valueType("Environment")),
        ProjectDependencyModel.`type`.head   -> List(valueType("Dependency")),
        API_INSTANCE_TERM                    -> List(valueType("APIInstance"))
    )
  }
}
