package org.mulesoft.apb.client.platform.extensions

import amf.core.client.platform.model.StrField
import amf.core.client.platform.model.domain.DomainElement
import org.mulesoft.apb.client.platform.model.Project
import org.mulesoft.apb.client.scala.extensions.{
  EnvironmentExtension => InternalEnvironmentExtension,
  InstanceEnvironment => InternalInstanceEnvironment
}
import org.mulesoft.apb.internal.convert.APBClientConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
trait APIProjectExtension {

  def extend(project: Project): Project
}

@JSExportAll
class EnvironmentExtension private[apb] (val _internal: InternalEnvironmentExtension) extends APIProjectExtension {

  @JSExportTopLevel("EnvironmentExtension")
  def this(envs: ClientList[InstanceEnvironment]) = this(InternalEnvironmentExtension(envs.asInternal))

  override def extend(project: Project): Project = _internal.extend(project)
}

@JSExportAll
// TODO: this should be private but I can't make it as DomainElement has private[amf]
class InstanceEnvironment private[apb] (val _internal: InternalInstanceEnvironment) extends DomainElement {

  @JSExportTopLevel("InstanceEnvironment")
  def this() = this(InternalInstanceEnvironment())

  def environmentId(): StrField = _internal.environmentId()
  def name(): StrField          = _internal.name()
  def `type`(): StrField        = _internal.`type`()

  def withEnvironmentId(value: String) = _internal.withEnvironmentId(value)
  def withName(value: String)          = _internal.withName(value)
  def withType(value: String)          = _internal.withType(value)
}
