package org.mulesoft.apb.internal.convert

import amf.core.client.platform.model.AmfObjectWrapper
import amf.core.client.scala.model.domain.{AmfObject, DomainElement => InternalDomainElement}
import amf.core.client.platform.model.domain.DomainElement
import amf.core.client.scala.model.document.BaseUnit
import amf.core.internal.convert.{ClientInternalMatcher, InternalClientMatcher}
import amf.core.internal.convert.{BidirectionalMatcher, ClientInternalMatcher, InternalClientMatcher}
import org.mulesoft.apb.client.platform.extensions.{
  APIProjectExtension => ClientAPIProjectExtension,
  InstanceEnvironment => ClientInstanceEnvironment
}
import org.mulesoft.apb.client.platform.model.{
  Project => ClientProject,
  ProjectDocument => ClientProjectDocument,
  ProjectInfo => ClientProjectInfo
}
import org.mulesoft.apb.client.platform.{
  ClientProjectNodeCache,
  APIInstanceClient => ClientAPIInstanceClient,
  APIProjectClient => ClientAPIProjectClient,
  ApiContractClient => ClientAPBClient
}
import org.mulesoft.apb.client.scala.extensions.{APIProjectExtension, InstanceEnvironment}
import org.mulesoft.apb.client.scala.model.{Project, ProjectDocument, ProjectInfo}
import org.mulesoft.apb.client.scala.{APIInstanceClient, APIProjectClient, ApiContractUnitClient, ProjectNodeCache}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
object APBClientConverters extends APBProjectConverters {

  implicit object APBClientClientConverter extends InternalClientMatcher[ApiContractUnitClient, ClientAPBClient] {
    override def asClient(from: ApiContractUnitClient): ClientAPBClient = new ClientAPBClient(from)
  }

  implicit object APBProjectConverter extends BidirectionalMatcher[Project, ClientProject] {
    override def asClient(from: Project): ClientProject = ClientProject(from)

    override def asInternal(from: ClientProject): Project = from._internal
  }

  implicit object APBProjectInfoConverter extends InternalClientMatcher[ProjectInfo, ClientProjectInfo] {
    override def asClient(from: ProjectInfo): ClientProjectInfo = new ClientProjectInfo(from)
  }

  implicit object APBProjectDocumentConverter extends InternalClientMatcher[ProjectDocument, ClientProjectDocument] {
    override def asClient(from: ProjectDocument): ClientProjectDocument = new ClientProjectDocument(from)
  }

  implicit object APBAPIInstanceClientConverter
      extends InternalClientMatcher[APIInstanceClient, ClientAPIInstanceClient] {
    override def asClient(from: APIInstanceClient): ClientAPIInstanceClient = new ClientAPIInstanceClient(from)
  }

  implicit object APBProjectClientConverter extends InternalClientMatcher[APIProjectClient, ClientAPIProjectClient] {
    override def asClient(from: APIProjectClient): ClientAPIProjectClient = new ClientAPIProjectClient(from)
  }

  implicit object APBClientProjectNodeCache extends ClientInternalMatcher[ClientProjectNodeCache, ProjectNodeCache] {
    override def asInternal(from: ClientProjectNodeCache): ProjectNodeCache = new ProjectNodeCache {
      override def fetch(uri: String): Option[Future[BaseUnit]] =
        toScalaOption(from.fetch(uri)).map(client => {
          asInternalFuture(client, BaseUnitMatcher)
        })
    }
  }

  implicit object InstanceEnvironmentConverter
      extends BidirectionalMatcher[InstanceEnvironment, ClientInstanceEnvironment] {
    override def asInternal(from: ClientInstanceEnvironment): InstanceEnvironment = from._internal

    override def asClient(from: InstanceEnvironment): ClientInstanceEnvironment = new ClientInstanceEnvironment(from)
  }

  implicit object ApiProjectExtensionMatcher
      extends ClientInternalMatcher[ClientAPIProjectExtension, APIProjectExtension] {
    override def asInternal(from: ClientAPIProjectExtension): APIProjectExtension = new APIProjectExtension {
      override def extend(project: Project): Project = from.extend(ClientProject(project))._internal
    }
  }
}
