package org.mulesoft.apb.internal.view

import amf.aml.client.scala.model.document.{DialectInstance, DialectInstanceProcessingData}
import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.config.RenderOptions
import amf.core.client.scala.model.domain.DomainElement
import amf.core.client.scala.vocabulary.{Namespace, NamespaceAliases}
import amf.core.internal.adoption.IdAdopter
import amf.core.internal.remote.Mimes.`application/ld+json`
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Api, Catalog, Anypoint, Contract, Management}

case class DialectInstanceView(schemaId: String, inner: ModelView[DomainElement]) extends ModelView[String] {

  private val schemaBase = s"$schemaId#/declarations/"

  private val aliases = Map(
      "api"        -> Api,
      "catalog"    -> Catalog,
      "anypoint"   -> Anypoint,
      "management" -> Management,
      "contract"   -> Contract,
      "schema"     -> Namespace(schemaBase)
  )

  override def view(element: DomainElement): String = {
    val encodes  = inner.view(element)
    val instance = createContainerInstance(schemaId)
    instance.withEncodes(encodes)
    adopt(instance)
    toJsonLd(instance)
  }

  private def adopt(instance: DialectInstance): Unit = {
    new IdAdopter(instance, "").adoptFromRoot()
  }

  private def toJsonLd(instance: DialectInstance): String = {
    val client = AMFGraphConfiguration
      .predefined()
      .withRenderOptions(RenderOptions().withPrettyPrint.withCompactUris)
      .withAliases(NamespaceAliases.withCustomAliases(aliases))
      .baseUnitClient()
    client.render(instance, `application/ld+json`)
  }

  private def createContainerInstance(schemaId: String) = {
    DialectInstance()
      .withRoot(true)
      .withProcessingData(DialectInstanceProcessingData().withTransformed(false).withDefinedBy(schemaId))
  }

}
