package org.mulesoft.apb.client.scala

import amf.core.client.scala.resource.ResourceLoader

class APIInstanceClientBuilder(instance: String) {

  private var schemaDefinitionUrl: Option[String]    = None
  private var resourceLoader: Option[ResourceLoader] = None

  def withSchemaDefinition(url: String): APIInstanceClientBuilder = {
    this.schemaDefinitionUrl = Some(url)
    this
  }

  def withResourceLoader(loader: ResourceLoader): APIInstanceClientBuilder = {
    this.resourceLoader = Some(loader)
    this
  }

  def build(): APIInstanceClient = APIInstanceClient(instance, schemaDefinitionUrl, resourceLoader)
}
