package org.mulesoft.apb.client.scala.model

import amf.apicontract.client.scala.model.domain.api.Api
import amf.core.client.scala.model.domain.DomainElement
import amf.core.internal.metamodel.Obj
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel._
import org.mulesoft.apb.project.client.scala.model.{ProjectBase, UnwrappedFields}

class ProjectInfo(override val fields: Fields, override val annotations: Annotations)
    extends DomainElement
    with ProjectBase {
  override def meta: Obj = ProjectInfoModel

  def apiContract(): Api              = fields.field(Contract)
  def instances(): List[JsonLDObject] = fields.field(Instances)
  override def componentId: String    = "projectInfo"
}

object ProjectInfo {
  def apply() = new ProjectInfo(Fields(), Annotations())
}
