package org.mulesoft.apb.internal.generated

import amf.core.internal.remote.Mimes
import org.mulesoft.apb.internal.loaders.InMemoryResourceLoader

object GCLSchemaDefaultRL {

  private val apiInstanceSchema = ApiInstanceSchema.schema

  private val policyBindingSchema = PolicyBindingSchema.schema

  val GCLUri: String = "file://gcl.anypoint"

  val GCLSchema: String = """{
                    |    "$schema": "http://json-schema.org/draft-07/schema#",
                    |    "oneOf": [""".stripMargin + apiInstanceSchema + ", " + policyBindingSchema + "]\n}"

  val resourceLoader: InMemoryResourceLoader = InMemoryResourceLoader(GCLUri, GCLSchema, Mimes.`application/json`)
}
