package org.mulesoft.apb.client.platform

import amf.core.client.platform.model.AmfObjectWrapper
import amf.core.client.platform.model.document.BaseUnit
import org.mulesoft.apb.project.client.platform.model.Project
import org.mulesoft.apb.client.scala.{APIProjectClient => InternalAPIProjectClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._

import scala.concurrent.ExecutionContext.Implicits.global

import scala.scalajs.js.annotation.{JSExport, JSExportAll}

// TODO native-jsonld: change policies for a list of generic runtime dependencies with their own definition for merging
@JSExportAll
class APIProjectClient private[apb] (private[apb] val _internal: InternalAPIProjectClient) {

  def build(): ClientFuture[Project]    = _internal.build().map(_.result).asClient
  def serialize(): ClientFuture[String] = _internal.serialize().asClient

  def serialize(project: Project): String = _internal.serialize(project)

  def summary(schemaBase: String): ClientFuture[String] = _internal.summary(schemaBase).asClient

  def summary(schemaBase: String, project: Project): String = _internal.summary(schemaBase, project)

}

trait ClientProjectNodeCache {
  def fetch(uri: String): ClientOption[ClientFuture[BaseUnit]]
}
