package org.mulesoft.apb.internal

import org.mulesoft.apb.project.client.scala.model.management.{APIInstance, PolicyBinding}
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{
  CONFIG,
  DESTINATION_REF,
  ENVIRONMENT,
  METADATA,
  NAME,
  POLICIES,
  SERVICE,
  SPEC
}

package object render {

  implicit class APIInstanceResourceOrientedTransformer(apiInstance: APIInstance) {
    def uninline(): APIInstance = {
      removePolicies()
      removeEnvironments()
      apiInstance
    }

    private def removePolicies(): Unit = {
      apiInstance.getObjectIfPresent(SPEC).map { spec =>
        apiInstance.policyBindings.foreach(_.withTargetRef(apiInstance.name))
        spec.removeProperty(POLICIES)
      }
    }

    private def removeEnvironments(): Unit = {
      apiInstance.getObjectIfPresent(SPEC).map { spec =>
        spec.removeProperty(ENVIRONMENT)
      }
    }
  }

  implicit class PolicyBindingResourceOrientedTransformer(policy: PolicyBinding) {

    def uninline(): PolicyBinding = {
      removeService()
      policy
    }

    private def removeService(): Unit = {
      policy.spec.getObjectIfPresent(CONFIG).foreach { config =>
        config.getObjectIfPresent(SERVICE).foreach { _ =>
          policy.withPolicyRef("route")
          config.update(DESTINATION_REF) { ref => ref.withProperty(NAME, policy.service.name) }
          config.graph.removeField(SERVICE)
        }
      }
    }
  }
}
