package org.mulesoft.apb.client.platform

import amf.core.client.platform.model.AmfObjectWrapper
import amf.core.client.platform.model.document.BaseUnit
import org.mulesoft.apb.client.platform.model.Project
import org.mulesoft.apb.client.scala.{APIProjectClient => InternalAPIProjectClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExport, JSExportAll}

// TODO native-jsonld: change policies for a list of generic runtime dependencies with their own definition for merging
@JSExportAll
class APIProjectClient private[apb] (private[apb] val _internal: InternalAPIProjectClient) {

  def build(): ClientFuture[Project]    = _internal.build().asClient
  def serialize(): ClientFuture[String] = _internal.serialize().asClient

}

trait ClientProjectNodeCache {
  def fetch(uri: String): ClientOption[ClientFuture[BaseUnit]]
}
