package org.mulesoft.apb.internal.convert

import amf.apicontract.client.scala.model.domain.api.Api
import amf.core.client.scala.model.document.BaseUnit
import amf.core.client.scala.AMFResult
import amf.core.client.scala.model.document.{Document, EncodesModel}
import amf.core.client.scala.model.domain.{AmfObject, DomainElement}
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject

object ElementConverters {

  case class UnmetClassExpectationError() extends Exception("Expected class of a specific type but found another")

  case class ElementWithoutEncodesError() extends Exception("Document doesn't have en encoded element")
  case class ApiWithoutEncodesError()     extends Exception("Parsed API doesn't have an encoded element")
  implicit class AmfObjectConverter(obj: AmfObject) {

    private def getEncodes() = {
      obj match {
        case jsonLDinstance: JsonLDInstanceDocument => jsonLDinstance.encodes.collect({ case obj: JsonLDObject => obj })
        case _                                      => throw ElementWithoutEncodesError()
      }
    }
    def as[T <: AmfObject](d: AmfObject): T = d match {
      case t: T => t
      case _    => throw UnmetClassExpectationError()
    }

    def toUnit(): BaseUnit = as[BaseUnit](obj)

    def toJsonLDObjects(): List[JsonLDObject] = getEncodes().toList
  }

  implicit class AMFResultConverter(r: AMFResult) {
    def encodedElement(): DomainElement = r.baseUnit match {
      case d: Document => d.encodes
      case _           => throw ApiWithoutEncodesError()
    }
  }

}
