package org.mulesoft.apb.internal.view

import amf.core.client.scala.model.domain.{AmfObject, DomainElement}
import amf.core.client.scala.vocabulary.{Namespace, ValueType}
import amf.core.internal.metamodel.{Field, ModelDefaultBuilder, Obj}
import amf.core.internal.parser.domain.{Annotations, Fields}

trait DomainElementCopier {

  def copy(obj: DomainElement): DomainElement
}

case class GraphObjectCopier(mappings: Map[ValueType, List[ValueType]]) extends DomainElementCopier {
  override def copy(obj: DomainElement): DomainElement = {
    val extraTypes = obj.meta.`type`.headOption.flatMap(mappings.get).getOrElse(List.empty)
    GraphObject(obj, extraTypes)
  }
}

case class GraphObject(inner: AmfObject, types: List[ValueType], fields: Fields = Fields()) extends DomainElement {
  override def meta: Obj = GraphObjectMeta(types, inner.meta)

  override def componentId: String = inner.componentId

  override val annotations: Annotations = inner.annotations
}

case class GraphObjectMeta(types: List[ValueType], inner: Obj) extends Obj {
  override val `type`: List[ValueType] = types ::: inner.`type`
  override def fields: List[Field]     = inner.fields
}

object AsIsElementCopier extends DomainElementCopier {
  override def copy(obj: DomainElement): DomainElement = {
    obj.meta.asInstanceOf[ModelDefaultBuilder].modelInstance.asInstanceOf[DomainElement]
  }
}
