package org.mulesoft.apb.client.scala

import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.client.scala.{APIProjectBuilder, ProjectConfiguration}
import org.mulesoft.apb.project.client.scala.dependency.{APBUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor
import org.mulesoft.apb.project.internal.validations.ProjectValidations.MissingMainFile

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class APIContractUnitClientBuilder(private val dependencyFetcher: DependencyFetcher) extends PlatformSecrets {

  private var resourceLoaders                     = platform.loaders().toList
  private var unitsCacheBuilder: UnitCacheBuilder = APBUnitCacheBuilder

  def withCacheBuilder(builder: UnitCacheBuilder): this.type = {
    this.unitsCacheBuilder = builder
    this
  }

  def withResourceLoaders(loaders: List[ResourceLoader]): this.type = {
    this.resourceLoaders = loaders
    this
  }

  def withResourceLoader(loader: ResourceLoader): this.type = {
    this.resourceLoaders = loader +: this.resourceLoaders
    this
  }
  def build(directory: String): Future[APIContractUnitClient] =
    getProjectBuilder.buildFromDirectory(directory).map(buildAPIContractClient)

  def build(descriptor: ProjectDescriptor): Future[APIContractUnitClient] =
    getProjectBuilder.build(descriptor).map(buildAPIContractClient)

  def buildFromContent(descriptorAsString: String, directory: Option[String]): Future[APIContractUnitClient] =
    getProjectBuilder.buildFromContent(descriptorAsString, directory).map(buildAPIContractClient)

  private def getProjectBuilder =
    new APIProjectBuilder(dependencyFetcher, resourceLoaders, unitsCacheBuilder)

  private def buildAPIContractClient(configuration: ProjectConfiguration) = {
    configuration.descriptor.main match {
      case Some(main) => new APIContractUnitClient(configuration, main)
      case _          => throw MissingMainFileException
    }
  }

}

object MissingMainFileException extends Exception(MissingMainFile.message)
