package org.mulesoft.apb.internal.convert

import amf.core.internal.convert.{BidirectionalMatcher, CoreBaseClientConverter}
import org.mulesoft.apb.project.internal.convert.ManagementBaseConverter

object APIInstanceHandlerConverter
    extends ManagementBaseConverter
    with APIInstanceParseResultConverter
    with CoreBaseClientConverter

trait APIInstanceParseResultConverter {
  private type InternalAPIInstanceParseResult = org.mulesoft.apb.client.scala.instances.APIInstanceParseResult
  private type ClientAPIInstanceParseResult   = org.mulesoft.apb.client.platform.instances.APIInstanceParseResult
  implicit object APIInstanceParseResultMatcher
      extends BidirectionalMatcher[InternalAPIInstanceParseResult, ClientAPIInstanceParseResult] {
    override def asClient(from: InternalAPIInstanceParseResult): ClientAPIInstanceParseResult =
      new ClientAPIInstanceParseResult(from)
    override def asInternal(from: ClientAPIInstanceParseResult): InternalAPIInstanceParseResult = from._internal
  }
}
