package org.mulesoft.apb.client.platform.instances
import amf.core.client.platform.validation.AMFValidationReport
import org.mulesoft.apb.client.scala.instances.{
  APIInstanceHandler => InternalAPIInstanceHandler,
  APIInstanceParseResult => InternalAPIInstanceParseResult
}
import org.mulesoft.apb.internal.convert.APIInstanceHandlerConverter._
import org.mulesoft.apb.project.client.platform.model.management.APIInstance

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import scala.concurrent.ExecutionContext.Implicits.global

@JSExportAll
case class APIInstanceParseResult private[apb] (private[apb] val _internal: InternalAPIInstanceParseResult) {
  def descriptor: APIInstance     = _internal.instance
  def report: AMFValidationReport = _internal.report
}
@JSExportAll
@JSExportTopLevel("APIInstanceHandler")
class APIInstanceHandler {
  def parse(content: String): ClientFuture[APIInstanceParseResult] =
    InternalAPIInstanceHandler().parse(content).asClient

  def parse(content: String, base: String): ClientFuture[APIInstanceParseResult] =
    InternalAPIInstanceHandler(base).parse(content).asClient

  def render(instance: APIInstance): String =
    InternalAPIInstanceHandler().render(instance.internal)
}
