package org.mulesoft.apb.client.platform

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import org.mulesoft.apb.client.scala.{APIDocumentationClient => InternalAPIDocumentationClient}
import org.mulesoft.apb.project.client.platform.model.BaseUnitBuildResult
import org.mulesoft.apb.internal.convert.APBClientConverters._
import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.project.client.platform.model.descriptor.documentation.Documentation

import scala.concurrent.ExecutionContext

@JSExportAll
class APIDocumentationClient private[apb] (private[apb] val _internal: InternalAPIDocumentationClient) {
  private implicit val ec: ExecutionContext = ExecutionContext.Implicits.global

  @JSExportTopLevel("APIDocumentationClient")
  def this(docNode: Documentation, rl: ClientOption[ResourceLoader]) = {
    this(new InternalAPIDocumentationClient(docNode, rl.toScala.map(APIDocumentationClient.adaptRL)))
  }

  def build(): ClientFuture[BaseUnitBuildResult] = _internal.build().asClient
}

object APIDocumentationClient {
  private[apb] def adaptRL(rl: ResourceLoader) = {
    ResourceLoaderMatcher.asInternal(rl)(ExecutionContext.Implicits.global)
  }
}
