package org.mulesoft.apb.client.scala

import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.client.scala.extensions.APIProjectExtension
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor

class APIProjectClientBuilder(descriptor: ProjectDescriptor, dependencyFetcher: DependencyFetcher) {

  private var loader: Option[ResourceLoader]       = None
  private var cache: Option[ProjectNodeCache]      = None
  private var extensions: Seq[APIProjectExtension] = List.empty

  def withResourceLoader(loader: ResourceLoader): APIProjectClientBuilder = {
    this.loader = Some(loader)
    this
  }

  def withCache(cache: ProjectNodeCache): APIProjectClientBuilder = {
    this.cache = Some(cache)
    this
  }

  def withExtensions(extensions: Seq[APIProjectExtension]): APIProjectClientBuilder = {
    this.extensions = extensions
    this
  }

  def build(): APIProjectClient = new APIProjectClient(descriptor, dependencyFetcher, loader, cache, extensions)
}
