package org.mulesoft.apb.internal.gcl

import org.mulesoft.apb.internal.generated.{ApiInstanceSchema, PolicyBindingSchema}
import org.mulesoft.apb.project.internal.instances.ResourceKind.{ApiInstance, PolicyBinding}

object SchemaProvider {

  def get(kind: String): Option[String] = schemas.get(kind)

  def all = schemas

  private val schemas: Map[String, String] = Map(
      ApiInstance.kind   -> ApiInstanceSchema.schema,
      PolicyBinding.kind -> PolicyBindingSchema.schema
  )
}
