package org.mulesoft.apb.client.platform.contract

import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.client.scala.contract.{APIContractClientBuilder => InternalAPBClientBuilder}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor

import scala.concurrent.ExecutionContext
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class APIContractClientBuilder private[apb] (private val internal: InternalAPBClientBuilder) {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global

  @JSExportTopLevel("ApiContractClientBuilder")
  def this(fetcher: DependencyFetcher) {
    this(InternalAPBClientBuilder(fetcher))
  }

  def withResourceLoaders(loaders: ClientList[ResourceLoader]): this.type = {
    internal.withResourceLoaders(loaders.asInternal.toList)
    this
  }

  def build(directory: String): ClientFuture[APIContractClient] = internal.build(directory).asClient

  def build(descriptor: ProjectDescriptor): ClientFuture[APIContractClient] = internal.build(descriptor).asClient

  def buildFromContent(descriptorAsString: String): ClientFuture[APIContractClient] =
    internal.buildFromContent(descriptorAsString).asClient
}
